/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.navigation.services;

import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLinkBuilder;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLinks;
import com.atlassian.plugins.navlink.producer.navigation.services.LocalNavigationLinkService;
import com.atlassian.plugins.navlink.producer.navigation.services.LocalNavigationLinks;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLink;
import com.atlassian.plugins.navlink.util.i18n.LocaleSupportingI18nResolverWorkAround;
import com.atlassian.plugins.navlink.util.url.UrlFactory;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalNavigationLinkServiceImpl
implements LocalNavigationLinkService {
    private final LocalNavigationLinks localNavigationLinks;
    private final UrlFactory urlFactory;
    private final InternalHostApplication internalHostApplication;
    private final LocaleSupportingI18nResolverWorkAround i18nResolverWorkAround;

    public LocalNavigationLinkServiceImpl(LocalNavigationLinks localNavigationLinks, UrlFactory urlFactory, InternalHostApplication internalHostApplication, LocaleSupportingI18nResolverWorkAround i18nResolverWorkAround) {
        this.localNavigationLinks = localNavigationLinks;
        this.urlFactory = urlFactory;
        this.internalHostApplication = internalHostApplication;
        this.i18nResolverWorkAround = i18nResolverWorkAround;
    }

    @Override
    @Nonnull
    public Set<NavigationLink> all(@Nonnull Locale locale) {
        Set<RawNavigationLink> all = this.localNavigationLinks.all();
        return Sets.newHashSet((Iterable)Iterables.transform(all, this.toNavigationLinkEntity(locale)));
    }

    @Override
    @Nonnull
    public Set<NavigationLink> matching(@Nonnull Locale locale, @Nonnull Predicate<NavigationLink> criteria) {
        return Sets.newHashSet((Iterable)Iterables.filter(this.all(locale), criteria));
    }

    @Nonnull
    private Function<? super RawNavigationLink, ? extends NavigationLink> toNavigationLinkEntity(final @Nonnull Locale locale) {
        return new Function<RawNavigationLink, NavigationLink>(){

            public NavigationLink apply(@Nullable RawNavigationLink localLink) {
                if (localLink != null) {
                    String href = LocalNavigationLinkServiceImpl.this.urlFactory.toAbsoluteUrl(localLink.getHref());
                    String label = LocalNavigationLinkServiceImpl.this.i18nResolverWorkAround.getText(locale, localLink.getLabelKey(), new Serializable[]{LocalNavigationLinkServiceImpl.this.internalHostApplication.getName()});
                    String tooltip = LocalNavigationLinkServiceImpl.this.i18nResolverWorkAround.getText(locale, localLink.getTooltipKey());
                    String icon = Strings.isNullOrEmpty((String)localLink.getIconUrl()) ? null : LocalNavigationLinkServiceImpl.this.urlFactory.toAbsoluteUrl(localLink.getIconUrl());
                    return ((NavigationLinkBuilder)((NavigationLinkBuilder)NavigationLinks.copyOf(localLink).href(href)).iconUrl(icon)).label(label).tooltip(tooltip).build();
                }
                return null;
            }
        };
    }
}

