/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.plugins.navlink.consumer.CachingApplicationLinkService;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class CachingApplicationLinkServiceImpl
implements CachingApplicationLinkService {
    private final ApplicationLinkService applicationLinkService;
    private final TransactionTemplate transactionTemplate;
    private final Cache<Object, Iterable<ApplicationLink>> links = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build(CacheLoader.from((Supplier)new Supplier<Iterable<ApplicationLink>>(){

        public Iterable<ApplicationLink> get() {
            return (Iterable)CachingApplicationLinkServiceImpl.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Iterable<ApplicationLink>>(){

                public Iterable<ApplicationLink> doInTransaction() {
                    return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)CachingApplicationLinkServiceImpl.this.applicationLinkService.getApplicationLinks(), (Function)new Function<ApplicationLink, ApplicationLink>(){

                        public ApplicationLink apply(@Nullable ApplicationLink from) {
                            return new ImmutableApplicationLink(from);
                        }
                    }));
                }
            });
        }
    }));

    public CachingApplicationLinkServiceImpl(ApplicationLinkService applicationLinkService, TransactionTemplate transactionTemplate) {
        this.applicationLinkService = applicationLinkService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public Iterable<ApplicationLink> getApplicationLinks() {
        return (Iterable)this.links.getUnchecked((Object)this);
    }

    @Override
    public ApplicationLink getApplicationLink(final ApplicationId applicationId) {
        Preconditions.checkNotNull((Object)applicationId);
        return (ApplicationLink)Iterables.getOnlyElement((Iterable)Iterables.filter(this.getApplicationLinks(), (Predicate)new Predicate<ApplicationLink>(){

            public boolean apply(ApplicationLink input) {
                return applicationId.equals((Object)input.getId());
            }
        }), null);
    }

    @Override
    public void clear() {
        this.links.invalidateAll();
    }

    private static class ImmutableApplicationLink
    implements ApplicationLink {
        private static final List<String> KNOWN_PROPERTY_KEYS = ImmutableList.of((Object)"IS_ACTIVITY_ITEM_PROVIDER");
        private final ApplicationId applicationId;
        private final ApplicationType applicationType;
        private final String name;
        private final URI displayUrl;
        private final URI rpcUrl;
        private final Map<String, Object> properties;

        public ImmutableApplicationLink(ApplicationLink that) {
            this.applicationId = that.getId();
            this.applicationType = that.getType();
            this.name = that.getName();
            this.displayUrl = that.getDisplayUrl();
            this.rpcUrl = that.getRpcUrl();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String knownPropertyKey : KNOWN_PROPERTY_KEYS) {
                Object property = that.getProperty(knownPropertyKey);
                if (property == null) continue;
                builder.put((Object)knownPropertyKey, property);
            }
            this.properties = builder.build();
        }

        public ApplicationId getId() {
            return this.applicationId;
        }

        public ApplicationType getType() {
            return this.applicationType;
        }

        public String getName() {
            return this.name;
        }

        public URI getDisplayUrl() {
            return this.displayUrl;
        }

        public URI getRpcUrl() {
            return this.rpcUrl;
        }

        public boolean isPrimary() {
            throw new UnsupportedOperationException("isPrimary not cached");
        }

        public boolean isSystem() {
            throw new UnsupportedOperationException("isSystem not cached");
        }

        public ApplicationLinkRequestFactory createAuthenticatedRequestFactory() {
            throw new UnsupportedOperationException("createAuthenticatedRequestFactory not available");
        }

        public ApplicationLinkRequestFactory createAuthenticatedRequestFactory(Class<? extends AuthenticationProvider> providerClass) {
            throw new UnsupportedOperationException("createAuthenticatedRequestFactory not available");
        }

        public ApplicationLinkRequestFactory createImpersonatingAuthenticatedRequestFactory() {
            throw new UnsupportedOperationException("createImpersonatingAuthenticatedRequestFactory not available");
        }

        public ApplicationLinkRequestFactory createNonImpersonatingAuthenticatedRequestFactory() {
            throw new UnsupportedOperationException("createNonImpersonatingAuthenticatedRequestFactory not available");
        }

        public Object getProperty(String key) {
            if (!KNOWN_PROPERTY_KEYS.contains(key)) {
                throw new UnsupportedOperationException("Property " + key + " not cached");
            }
            return this.properties.get(key);
        }

        public Object putProperty(String key, Object value) {
            throw new UnsupportedOperationException("putProperty not allowed on immutable applink");
        }

        public Object removeProperty(String key) {
            throw new UnsupportedOperationException("removeProperty not allowed on immutable applink");
        }

        public String toString() {
            return String.format("%s (%s) %s %s", this.name, this.applicationId, this.rpcUrl, this.applicationType);
        }
    }
}

