/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.analyticsdata.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/")
@AnonymousAllowed
public class AnalyticsDataResource {
    private final UserManager userManager;

    public AnalyticsDataResource(UserManager userManager) {
        this.userManager = userManager;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAnalyticsData() {
        String username = this.userManager.getRemoteUsername();
        boolean isUserAdmin = username != null && this.userManager.isAdmin(username);
        return Response.ok((Object)new AnalyticsData(isUserAdmin)).build();
    }

    @XmlRootElement
    public static class AnalyticsData {
        @XmlElement
        public final Boolean isUserAdmin;

        public AnalyticsData(Boolean userAdmin) {
            this.isUserAdmin = userAdmin;
        }
    }
}

