package com.atlassian.plugins.navlink.util.executor;

import com.google.common.collect.ImmutableList;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * An executor service that provides a thread pool with threads running as daemon.
 * This allows the one thread pool to be shared across the nav-links and project shortcuts
 * clients.
 *
 */
public interface DaemonExecutorService extends ScheduledExecutorService
{
    // Size chosen arbitrarily for 3 concurrent requests to 4 linked apps
    final int THREAD_POOL_SIZE = Integer.getInteger("navlink.executor.threadpool", 12);
    
    final int THREAD_POOL_PRIORITY = Integer.getInteger("navlink.executor.priority", Thread.NORM_PRIORITY);
    
    final int DEFAULT_TIMEOUT_MS = Integer.getInteger("navlink.executor.timeout", 5000);
    
    /**
     * Invokes the list of callables and gets the results from the futures if they successfully completed
     * before the timeout.  Tasks that timedout are skipped.
     * 
     * @param callables - a list of callables, where possible the callables should do their own error handling rather than cause an ExecutionException
     *  to be thrown
     * @return the flattened list of results.
     * @throws ExecutionException
     * @throws InterruptedException
     */
    public <O, I extends Iterable<O>> ImmutableList<O> invokeAllAndGet(Iterable<? extends Callable<I>> callables, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException;
}
