package com.atlassian.plugins.navlink.util;

import java.util.Set;

import com.atlassian.plugins.navlink.consumer.menu.services.MenuService;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;

import com.google.common.collect.ImmutableSet;

public class ShowAppSwitcherFunction implements SoyServerFunction<Boolean>, SoyClientFunction
{
    private final MenuService menuService;
    private final UserManager userManager;


    public ShowAppSwitcherFunction(final MenuService menuService, final UserManager userManager)
    {
        this.menuService = menuService;
        this.userManager = userManager;
    }

    @Override
    public String getName()
    {
        return "showAppSwitcher";
    }

    @Override
    public JsExpression generate(final JsExpression... args)
    {
        /**
         * Dunno why this is called on client side - it seems that some code in the soy template is shared between the
         * actually-show-app-switcher evaluation on server side and the populate-app-switcher on client side.
         */
        return alwaysRenderAppSwitcherOnClientSide();
    }

    private JsExpression alwaysRenderAppSwitcherOnClientSide()
    {
        return new JsExpression("true");
    }

    @Override
    public Boolean apply(final Object... args)
    {
        return menuService.isAppSwitcherVisibleForUser(userManager.getRemoteUsername());
    }

    @Override
    public Set<Integer> validArgSizes()
    {
        return ImmutableSet.of(0);
    }
}
