package com.atlassian.plugins.navlink.util;

import org.apache.commons.lang.time.FastDateFormat;

import javax.annotation.Nonnull;
import java.util.Locale;
import java.util.TimeZone;

/**
 * @since 3.2
 * @see http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1
 */
public class LastModifiedFormatter {

    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance("EEE, dd MMM yyyy HH:mm:ss 'GMT'", TimeZone.getTimeZone("GMT"), Locale.ENGLISH);

    /**
     * @param millis the timestamp to be formated
     * @return the timestamp in the <code>Last-Modified</code> HTTP header format; always in {@link Locale#ENGLISH} and
     * based on GMT time zone.
     */
    @Nonnull
    public static String format(long millis) {
        return DATE_FORMAT.format(millis);
    }

    /**
     * @return the current timestamp in the <code>Last-Modified</code> HTTP header format; always in
     * {@link Locale#ENGLISH} and based on GMT time zone.
     */
    @Nonnull
    public static String formatCurrentTimeMillis() {
        return format(System.currentTimeMillis());
    }
}
