package com.atlassian.plugins.navlink.util;

import com.atlassian.plugins.navlink.util.darkfeatures.DarkFeatureService;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;

import java.util.Set;

public class IsSideBarEnabledFunction implements SoyServerFunction<Boolean>, SoyClientFunction
{
    private static final String FEATURE_KEY = "rotp.sidebar";

    private final DarkFeatureService darkFeatureService;

    public IsSideBarEnabledFunction(final DarkFeatureService darkFeatureService)
    {
        this.darkFeatureService = darkFeatureService;
    }

    @Override
    public JsExpression generate(final JsExpression... jsExpressions)
    {
        return new JsExpression("AJS.DarkFeatures.isEnabled('" + FEATURE_KEY + "')");
    }

    @Override
    public String getName()
    {
        return "isSideBarEnabled";
    }

    @Override
    public Boolean apply(final Object... objects)
    {
        return darkFeatureService.isDarkFeatureEnabledForCurrentUser(FEATURE_KEY);
    }

    @Override
    public Set<Integer> validArgSizes()
    {
        return ImmutableSet.of(0);
    }
}
