package com.atlassian.plugins.navlink.producer.navigation.services;

import com.google.common.base.Predicate;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * A set of static factory methods to create {@link Predicate} objects to specify filter criteria for
 * {@link RawNavigationLink links} stored in this repository.
 */
public class RawNavigationLinkPredicates
{
    public static Predicate<RawNavigationLink> keyEquals(final String key)
    {
        checkNotNull(key, "key");
        return new Predicate<RawNavigationLink>()
        {
            @Override
            public boolean apply(RawNavigationLink input)
            {
                return key.equals(input.getKey());
            }
        };
    }

}
