package com.atlassian.plugins.navlink.producer.navigation.services;

import com.atlassian.plugins.navlink.producer.navigation.links.NavigationLinkBase;
import com.google.common.base.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * 'Raw' Navigation link provided by or defined in the host application.
 * <p/>
 * Label and tooltip are not translated, relative URLs not resolved.
 */
@Immutable
public final class RawNavigationLink extends NavigationLinkBase
{
    private final String labelKey;
    private final String tooltipKey;

    RawNavigationLink(RawNavigationLinkBuilder builder)
    {
        super(builder);
        this.labelKey = checkNotNull(builder.labelKey);
        this.tooltipKey = builder.tooltipKey;
    }

    @Nonnull
    public String getLabelKey()
    {
        return labelKey;
    }

    @Nullable
    public String getTooltipKey()
    {
        return tooltipKey;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final RawNavigationLink that = (RawNavigationLink) o;
        return isEqualTo(that) &&
                Objects.equal(labelKey, that.labelKey) &&
                Objects.equal(tooltipKey, that.tooltipKey);

    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(hashCodeBase(), labelKey, tooltipKey);
    }

    @Override
    public String toString()
    {
        return "RawNavigationLink{" + toStringBase() +
                ", labelKey='" + labelKey + '\'' +
                ", tooltipKey='" + tooltipKey + '\'' +
                '}';
    }
}
