package com.atlassian.plugins.navlink.producer.navigation.services;

import com.google.common.base.Predicate;

/**
 * Provides a collection like interface over the underlying {@link RawNavigationLink} persistence implementation.
 *
 * The repository is responsible for fetching these objects from the underlying persistence implementation based on a given
 * criteria.
 *
 * @since 1.3
 */
public interface NavigationLinkRepository
{
    /**
     * Retrieves the navigation links matching the specified criteria.
     *
     * @param criteria The criteria to use to filter the links to be returned.
     *
     * @return An {@link Iterable} containing the navigation links which match the specified criteria.
     */
    public Iterable<RawNavigationLink> matching(final Predicate<RawNavigationLink> criteria);

    /**
     * Retrieves <em>all</em> the navigation links stored in this repository.
     *
     * @return An {@link Iterable} containing <em>all</em> the navigation links stored in this repository.
     */
    public Iterable<RawNavigationLink> all();

}
