package com.atlassian.plugins.navlink.producer.navigation.services;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * Merges the navigation links of multiple {@link NavigationLinkRepository}s into one single result list.
 *
 * @since 1.3
 */
public class LocalNavigationLinksImpl implements LocalNavigationLinks
{
    private final Logger logger = LoggerFactory.getLogger(LocalNavigationLinksImpl.class);
    private final NavigationLinkRepositoryService navigationLinkRepositoryService;

    public LocalNavigationLinksImpl(final NavigationLinkRepositoryService navigationLinkRepositoryService)
    {
        this.navigationLinkRepositoryService = navigationLinkRepositoryService;
    }

    @Nonnull
    @Override
    public Set<RawNavigationLink> all()
    {
        final List<NavigationLinkRepository> navigationLinkRepositoryList = navigationLinkRepositoryService.getAllNavigationLinkRepositories();
        final List<Iterable<RawNavigationLink>> navigationLinkEntityList = Lists.transform(navigationLinkRepositoryList, getAllLocalNavigationLinks());
        return Sets.newHashSet(Iterables.concat(navigationLinkEntityList));
    }

    @Nonnull
    private Function<NavigationLinkRepository, Iterable<RawNavigationLink>> getAllLocalNavigationLinks()
    {
        return new Function<NavigationLinkRepository, Iterable<RawNavigationLink>>()
        {
            @Override
            public Iterable<RawNavigationLink> apply(@Nullable final NavigationLinkRepository input)
            {
                try
                {
                    if (input != null)
                    {
                        return input.all();
                    }
                }
                catch (RuntimeException e)
                {
                    logger.warn("Failed to gather navigation links", e);
                }
                return Collections.emptyList();
            }
        };
    }

}
