package com.atlassian.plugins.navlink.producer.navigation.rest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import javax.annotation.concurrent.Immutable;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@Immutable
@XmlJavaTypeAdapter(MenuItemKeyTypeAdapter.class)
public class MenuItemKey
{
    private final String key;

    public MenuItemKey(final String key)
    {
        this.key = key;
    }

    public String get()
    {
        return key;
    }

    @Override
    public int hashCode()
    {
        return new HashCodeBuilder().append(key).toHashCode();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == null)
        {
            return false;
        }
        if (obj == this)
        {
            return true;
        }
        if (obj.getClass() != getClass())
        {
            return false;
        }

        final MenuItemKey rhs = (MenuItemKey) obj;

        return new EqualsBuilder().
                append(key, rhs.key).
                isEquals();
    }

    @Override
    public String toString()
    {
        return key;
    }
}
