package com.atlassian.plugins.navlink.producer.navigation.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugins.navlink.producer.navigation.services.NavigationLinkRepository;
import com.atlassian.util.concurrent.NotNull;
import org.dom4j.Element;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.3
 */
public class NavigationLinksModuleDescriptor extends AbstractModuleDescriptor<NavigationLinkRepository>
{
    private String navigationLinkRepositoryClassName;
    private NavigationLinkRepository navigationLinkRepositoryInstance;

    public NavigationLinksModuleDescriptor(@Nonnull final ModuleFactory moduleFactory)
    {
        super(checkNotNull(moduleFactory));
    }

    @Override
    public void init(@NotNull final Plugin plugin, @NotNull final Element element) throws PluginParseException
    {
        super.init(plugin, checkNotNull(element));
        navigationLinkRepositoryClassName = element.attributeValue("class");
        if (navigationLinkRepositoryClassName == null)
        {
            throw exceptionWhileParsing("class attribute is mandatory");
        }
        else if (navigationLinkRepositoryClassName.trim().isEmpty())
        {
            throw exceptionWhileParsing("class attribute must not be empty");
        }
    }

    @Override
    public void enabled()
    {
        super.enabled();
        navigationLinkRepositoryInstance = moduleFactory.createModule(moduleClassName, this);
    }

    @Nonnull
    @Override
    public NavigationLinkRepository getModule()
    {
        return navigationLinkRepositoryInstance;
    }

    private PluginParseException exceptionWhileParsing(@Nonnull final String reason)
    {
        return new PluginParseException(String.format("failed to parse plugin module %s; reason: %s", getCompleteKey(), reason));
    }

}
