package com.atlassian.plugins.navlink.producer.navigation.plugin;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.navlink.producer.navigation.services.NavigationLinkRepository;
import com.atlassian.plugins.navlink.producer.navigation.services.NavigationLinkRepositoryService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Returns all currently enabled navigation link plugin modules.
 *
 * @since 1.3
 */
public class NavigationLinkRepositoryServiceImpl implements NavigationLinkRepositoryService
{
    private final PluginAccessor pluginAccessor;

    public NavigationLinkRepositoryServiceImpl(@Nonnull final PluginAccessor pluginAccessor)
    {
        this.pluginAccessor = checkNotNull(pluginAccessor);
    }

    @Nonnull
    @Override
    public List<NavigationLinkRepository> getAllNavigationLinkRepositories()
    {
        List<NavigationLinksModuleDescriptor> enabledModuleDescriptorsByClass = pluginAccessor.getEnabledModuleDescriptorsByClass(NavigationLinksModuleDescriptor.class);
        return Lists.transform(enabledModuleDescriptorsByClass, new Function<NavigationLinksModuleDescriptor, NavigationLinkRepository>()
        {
            @Override
            public NavigationLinkRepository apply(@Nullable final NavigationLinksModuleDescriptor modulDescriptor)
            {
                return modulDescriptor != null ? modulDescriptor.getModule() : null;
            }
        });
    }
}