package com.atlassian.plugins.navlink.producer.navigation;

import com.atlassian.plugins.custom_apps.api.CustomApp;
import com.google.common.base.Predicate;
import org.apache.commons.lang.StringEscapeUtils;

public class NavigationLinkPredicates
{
    public static Predicate<NavigationLink> keyEquals(final String keyToMatch)
    {
        return new KeyEquals(keyToMatch);
    }

    public static Predicate<NavigationLink> matchesCustomApp(final CustomApp customApp)
    {
        return new MatchesCustomApp(customApp);
    }

    private static class KeyEquals implements Predicate<NavigationLink>
    {
        private final String keyToMatch;

        public KeyEquals(final String keyToMatch)
        {
            this.keyToMatch = keyToMatch;
        }

        @Override
        public boolean apply(final NavigationLink link)
        {
            return link.getKey().equals(keyToMatch);
        }
    }

    private static class MatchesCustomApp implements Predicate<NavigationLink>
    {
        private final CustomApp customApp;

        private MatchesCustomApp(CustomApp customApp)
        {
            this.customApp = customApp;
        }

        @Override
        public boolean apply(NavigationLink navLink)
        {
            return StringEscapeUtils.unescapeHtml(navLink.getLabel()).equals(customApp.getDisplayName()) && navLink.getHref().equals(customApp.getUrl());
        }
    }
}
