package com.atlassian.plugins.navlink.producer.contentlinks.services;

import com.atlassian.applinks.api.EntityLink;
import com.atlassian.plugins.navlink.producer.capabilities.CapabilityKey;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

class ContentLinkCapability
{
    private EntityLink entityLink;
    private String contentLinkUrl;

    /**
     * Creates a list of ContentLinkCapabilities, mapping from the RemoteApplicationWithCapabilities to the appropriate entity link.
     * Mapping is performed on the basis of applicationLinkId.
     * 
     * @param applications
     * @param entityLinks
     * @return
     */
    public static List<ContentLinkCapability> create(Iterable<RemoteApplicationWithCapabilities> applications, Iterable<EntityLink> entityLinks)
    {
        final ImmutableList.Builder<ContentLinkCapability> contentLinkCapabilities = ImmutableList.builder();

        Map<String, RemoteApplicationWithCapabilities> appCapabilitiesByAppLinkId = Maps.newHashMap();
        for (RemoteApplicationWithCapabilities app : applications)
        {
            if (app.hasCapability(CapabilityKey.CONTENT_LINKS))
            {
                appCapabilitiesByAppLinkId.put(app.getApplicationLinkId(), app);
            }
        }
        for (EntityLink entityLink : entityLinks)
        {
            String appLinkId = entityLink.getApplicationLink().getId().toString();
            if (appCapabilitiesByAppLinkId.containsKey(appLinkId))
            {
                contentLinkCapabilities.add(new ContentLinkCapability(entityLink, appCapabilitiesByAppLinkId.get(
                        appLinkId).getCapabilityUrl(CapabilityKey.CONTENT_LINKS)));
            }
        }
        return contentLinkCapabilities.build();
    }

    ContentLinkCapability(EntityLink entityLink, String contentLinkUrl)
    {
        this.entityLink = entityLink;
        this.contentLinkUrl = contentLinkUrl;
    }

    public String getContentLinkUrl()
    {
        return contentLinkUrl;
    }

    public EntityLink getEntityLink()
    {
        return entityLink;
    }
}
