package com.atlassian.plugins.navlink.producer.contentlinks.rest;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;import java.lang.Override;import java.lang.String;

@XmlRootElement(name = "content-link")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ContentLinkEntity
{
    private String link;
    private String label;
    private String tooltip;
    private boolean custom;

    public ContentLinkEntity()
    {
    }

    public ContentLinkEntity(String link, String label, String tooltip, boolean isCustom)
    {
        this.link = link;
        this.label = label;
        this.tooltip = tooltip;
        this.custom = isCustom;
    }

    public String getLink()
    {
        return link;
    }

    public String getLabel()
    {
        return label;
    }

    public String getTooltip()
    {
        return tooltip;
    }

    public boolean isCustom()
    {
        return custom;
    }

    public void setCustom(boolean isCustom)
    {
        this.custom = isCustom;
    }

    public void setLink(String link)
    {
        this.link = link;
    }

    public void setLabel(String label)
    {
        this.label = label;
    }

    public void setTooltip(String tooltip)
    {
        this.tooltip = tooltip;
    }

    @Override
    public String toString()
    {
        return "NavigationShortcut{" + ", link='" + link + '\'' + ", label='" + label + '\'' + ", tooltip='" + tooltip +
                '\'' + ", custom='" + custom + '\'' + '}';
    }

    public static ContentLinkEntity EXAMPLE = new ContentLinkEntity("http://my.jira.server/secure/browse/MY_PROJECT", "My Awesome Project Home", "Go to the home page for My Awesome Project", false);

}

