package com.atlassian.plugins.navlink.producer.contentlinks.plugin;

import static com.google.common.base.Preconditions.checkNotNull;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.CustomContentLinkProvider;
import com.atlassian.util.concurrent.NotNull;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class CustomContentLinkProviderModuleDescriptor extends AbstractModuleDescriptor<CustomContentLinkProvider>
{
    private CustomContentLinkProvider linkProviderInstance;

    public CustomContentLinkProviderModuleDescriptor(@NotNull ModuleFactory moduleFactory)
    {
        super(checkNotNull(moduleFactory));
    }

    @Override
    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException
    {
        super.init(plugin, checkNotNull(element));
        String classAttr = element.attributeValue("class");
        if (StringUtils.isBlank(classAttr))
        {
            throw new PluginParseException(String.format("Could not parse plugin module %s. "
                    + "Class attribute is mandatory and should not be blank", getPluginKey()));
        }
    }

    @Override
    public CustomContentLinkProvider getModule()
    {
        return linkProviderInstance;
    }

    @Override
    public void enabled()
    {
        super.enabled();
        linkProviderInstance = moduleFactory.createModule(moduleClassName, this);
    }
}
