package com.atlassian.plugins.navlink.producer.contentlinks.plugin;

import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.plugin.web.descriptors.AbstractWebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.DefaultWebLink;
import com.atlassian.plugin.web.model.WebLink;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ContentLinkModuleDescriptor extends AbstractWebFragmentModuleDescriptor<Void>
{
    private WebLink link;
    private Set<TypeId> entityTypes;

    @Override
    public Void getModule()
    {
        // just use the module descriptor directly.
        return null;
    }

    @Override
    public void enabled()
    {
        super.enabled();

        // contextProvider is not available until the module is enabled because they may need to have dependencies injected
        if (element.element("link") != null)
        {
            link = new DefaultWebLink(element.element("link"), webInterfaceManager.getWebFragmentHelper(), contextProvider, this);
        }

        final Set<TypeId> entities = new HashSet<TypeId>();
        for (Element contextElement : (List<Element>) element.elements("entityType"))
        {
            final String typeString = contextElement.getTextTrim();
            if (StringUtils.isNotBlank(typeString))
            {
                entities.add(new TypeId(typeString));
            }
        }
        entityTypes = Collections.unmodifiableSet(entities);
    }

    public WebLink getLink()
    {
        return link;
    }

    /**
     * Defines the entity types that this content link is applicable for.
     * You can specify none, one or many.
     * If none, this content link is will be available for any entity type.
     * If one or many, the content link will not be used unless the calling entity is listed.
     * The entityType string should be equivalent to the {@link TypeId} used in the applinks' {@link EntityType}
     */
    public Set<TypeId> getEntityTypes()
    {
        return entityTypes;
    }
}
