package com.atlassian.plugins.navlink.producer.capabilities.services;

import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.application.TypeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationTypeServiceImpl implements ApplicationTypeService
{
    private final Logger logger = LoggerFactory.getLogger(ApplicationTypeServiceImpl.class);
    private final InternalHostApplication internalHostApplication;

    public ApplicationTypeServiceImpl(InternalHostApplication internalHostApplication)
    {
        this.internalHostApplication = internalHostApplication;
    }

    @Override
    public String get()
    {
        final ApplicationType type = internalHostApplication.getType();
        try
        {
            return TypeId.getTypeId(type).get();
        }
        catch (RuntimeException e)
        {
            logger.warn("Failed to retrieve application type; returning default '{}'. Error message: {}", new Object[] {DEFAULT_APPLICATION_TYPE, e.getMessage()});
            logger.debug("Stacktrace:", e);
            return DEFAULT_APPLICATION_TYPE;
        }
    }

}
