package com.atlassian.plugins.navlink.consumer.menu.services;

import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Locale;


/**
 * All navigation links provided by the local application and available through linked ones.
 *
 * @since 1.0
 */
public interface MenuService
{
    /**
     * Retrieves the menu items matching the specified key.
     * @param key The key of the menu items to be retrieved
     * @param userName The name of the user to check visibility against
     * @param locale the language in which the items should be returned; this based on best-effort and not every remote
     *               application might support the specified language. In that case, the remote application's default
     *               language is returned
     * @return A list of navlinks representing menu items matching an specified key in a certain order
     */
    @Nonnull
    Iterable<NavigationLink> getMenuItems(@Nonnull String key, String userName, Locale locale);

    /**
     * Retrieve the menu items for the 'home' key, i.e. the App Switcher.
     *
     * @param userName name of the user to check visibility against
     * @return list of navigation list for the 'Home' ('App switcher') menu for the given user
     */
    @Nonnull
    Iterable<NavigationLink> getAppSwitcherItems(String userName);

    /**
     * Returns <code>true</code> if the given user has at least one menu item in the application navigator. The host's
     * home entry is ignored.
     * @param userName name of the user to check visibility against
     * @return <code>true</code> if the given user has at least one menu item in the application navigation,
     * <code>false</code> otherwise
     */
    boolean isAppSwitcherVisibleForUser(@Nullable String userName);
}
