package com.atlassian.plugins.navlink.consumer.menu.services;

import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLinkBuilder;
import com.google.common.base.Function;
import com.google.common.base.Strings;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.net.URI;

public class MaskBitbucketNavigationLinkTransformer implements Function<NavigationLink, NavigationLink>
{
    public static final MaskBitbucketNavigationLinkTransformer INSTANCE = new MaskBitbucketNavigationLinkTransformer();
    private static final String BITBUCKET = "bitbucket";

    @Override
    public NavigationLink apply(@Nullable final NavigationLink menuNavigationLink)
    {
        return menuNavigationLink != null ? transformLink(menuNavigationLink) : null;
    }

    @Nonnull
    private NavigationLink transformLink(@Nonnull final NavigationLink menuNavigationLink)
    {
        final String authority = Strings.nullToEmpty(getAuthority(menuNavigationLink));
        if (authority.toLowerCase().contains("bitbucket.org"))
        {
            return NavigationLinkBuilder.copyOf(menuNavigationLink)
                    .applicationType(BITBUCKET).build();
        }
        return menuNavigationLink;
    }

    @Nullable
    private String getAuthority(@Nonnull final NavigationLink menuNavigationLink)
    {
        final URI uri = asUri(menuNavigationLink);
        return uri != null ? uri.getAuthority() : null;
    }

    @Nullable
    private URI asUri(@Nonnull final NavigationLink menuNavigationLink)
    {
        try
        {
            return URI.create(menuNavigationLink.getHref());
        }
        catch (RuntimeException e)
        {
            return null;
        }
    }
}
