package com.atlassian.plugins.navlink.consumer.http.caching;

import com.atlassian.failurecache.ExpiringValue;
import org.apache.http.HttpResponse;

import javax.annotation.Nullable;

public interface HttpCacheExpiryService
{
    /**
     * @param response the HTTP response which contains the expiration date of the given value
     * @param value the value to be tagged with the expiration date
     * @param <V> the class of the value to be tagged
     * @return the given value tagged with the expiration date found in the HTT response.
     */
    <V> ExpiringValue<V> createExpiringValueFrom(HttpResponse response, @Nullable V value);
}
