package com.atlassian.plugins.navlink.consumer.http;

import com.atlassian.failurecache.ExpiringValue;
import org.apache.http.client.ResponseHandler;

import java.io.IOException;

public interface HttpRequestFactory
{
    /**
     * Execute a GET request to the given request url and pass the result to the response handler. Depending on the
     * underlying implementation, the request can be served directly from the cache without sending any network request.
     * The expiry date is based on the received response.
     * @param url the url to be requested
     * @param responseHandler the handler to be invoked with the received response
     * @param <T> the type the response handler is going to return
     * @return an expiring value which contains the result of the response handler for the received response
     * @throws IOException
     */
    <T> ExpiringValue<T> executeGetRequest(String url, ResponseHandler<T> responseHandler) throws IOException;
}
