package com.atlassian.plugins.navlink.consumer;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;

/**
 * Provides methods for retrieving {@link ApplicationLink}s representing linked applications (e.g. JIRA, Confluence,
 * etc.). Modelled on {@link CachingApplicationLinkService}.
 *
 * @since 3.1.13
 */
public interface CachingApplicationLinkService
{
    /**
     * Retrieves all {@link ApplicationLink}s.
     *
     * @return an {@link Iterable} of stored {@link ApplicationLink}s, of all
     * {@link com.atlassian.applinks.api.ApplicationType}s.
     */
    Iterable<ApplicationLink> getApplicationLinks();

    /**
     * Retrieves an {@link ApplicationLink} by its {@link ApplicationId}. Use this method only if you know the
     * {@link ApplicationId} of an existing {@link ApplicationLink}. If you storing an {@link ApplicationId} for
     * future look-ups using this method, you should listen for the {@link com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent} to ensure
     * your stored {@link ApplicationId} is kept current.
     *
     * @param applicationId the {@link ApplicationId} of a stored {@link ApplicationLink}.
     * @return the {@link ApplicationLink} specified by the id, or {@code null} if it does not exist
     */
    ApplicationLink getApplicationLink(ApplicationId applicationId);

    /**
     * Clears the cache.
     */
    void clear();
}
