package com.atlassian.plugins.custom_apps.util.servlet;

import javax.servlet.http.HttpServletRequest;
import java.net.URI;

/**
 * Contains static utility methods that act upon a {@link javax.servlet.http.HttpServletRequest}
 */
public class HttpServletRequests
{
    public static URI getUri(HttpServletRequest request)
    {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null)
        {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}
