package com.atlassian.plugins.custom_apps.security.authentication;

import java.io.IOException;
import java.net.URI;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.atlassian.plugins.custom_apps.util.servlet.HttpServletRequests;
import com.atlassian.sal.api.auth.LoginUriProvider;

/**
 * Represents the host product's login page.
 *
 */
public class LoginPage
{
    private final LoginUriProvider loginUriProvider;

    private static final String JIRA_SERAPH_SECURITY_ORIGINAL_URL = "os_security_originalurl";
    private static final String CONF_SERAPH_SECURITY_ORIGINAL_URL = "seraph_originalurl";

    public LoginPage(final LoginUriProvider loginUriProvider)
    {
        this.loginUriProvider = loginUriProvider;
    }

    public String getRedirectUrl(final HttpServletRequest request)
    {
        final URI requestUri = HttpServletRequests.getUri(request);
        return loginUriProvider.getLoginUri(requestUri).toASCIIString();
    }

    public String getRedirectUrl(final URI requestUri)
    {
        return loginUriProvider.getLoginUri(requestUri).toASCIIString();
    }

    public void redirect(final HttpServletRequest request, final HttpServletResponse response) throws IOException
    {
        final URI requestUri = HttpServletRequests.getUri(request);
        addSessionAttributes(request, requestUri.toASCIIString());
        response.sendRedirect(getRedirectUrl(requestUri));
    }

    private void addSessionAttributes(final HttpServletRequest request, final String uriString)
    {
        // Seraph tries to be clever and if the currently logged in user is trying to access a
        // URL that does not have a Seraph role restriction then it will redirect to os_destination.
        //
        // We do not want this behavior since we do have an elevated Seraph role but have not way to
        // programatically tell Seraph about it.

        // this is the JIRA specific string to let Seraph know that it should re-show the login page
        request.getSession().setAttribute(JIRA_SERAPH_SECURITY_ORIGINAL_URL, uriString);

        // this is the Confluence specific string to let Seraph know that it should re-show the login page
        request.getSession().setAttribute(CONF_SERAPH_SECURITY_ORIGINAL_URL, uriString);
    }
}
