package com.atlassian.plugins.custom_apps.rest.data;

import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
/**
 * Data transfer representation of CustomApp data for REST services.
 */
public class CustomAppData {
    public CustomAppData(String id, String displayName, String url, String applicationType, Boolean hide, boolean editable, List<String> allowedGroups, String sourceApplicationUrl, String sourceApplicationName, boolean self) {
        this.id = id;
        this.displayName = displayName;
        this.url = url;
        this.applicationType = applicationType;
        this.hide = hide;
        this.editable = editable;
        this.allowedGroups = allowedGroups;
        this.sourceApplicationUrl = sourceApplicationUrl;
        this.sourceApplicationName = sourceApplicationName;
        this.self = self;
    }

    public CustomAppData() {
    }

    public String id;
    public String url;
    public String displayName;
    public String applicationType;
    // Boolean rather than boolean as it is an editable field onscreen and therefore null implies "not set"
    public Boolean hide;
    public boolean editable;
    public List<String> allowedGroups;
    public String sourceApplicationUrl;
    public String sourceApplicationName;

    /**
     * Flag indicating if the current instance represents the host application.
     */
    public boolean self;
}
