package com.atlassian.plugins.custom_apps;

import com.atlassian.plugins.custom_apps.api.CustomApp;

import javax.annotation.Nullable;
import java.util.List;

/**
 * Service to store and retrieve {@link CustomApp} objects
 *
 * @since v3.1.15
 */
public interface CustomAppStore
{
    /* Constants for field names */
    public static final String ID = "id";
    public static final String DISPLAY_NAME = "displayName";
    public static final String URL = "url";
    public static final String BASE_URL = "baseUrl";
    public static final String HIDE = "hide";
    public static final String EDITABLE = "editable";
    public static final String APPLICATION_TYPE = "applicationType";
    public static final String APPLICATION_NAME = "applicationName";
    public static final String ALLOWED_GROUPS = "allowedGroups";
    public static final String SELF = "self";

    /**
     * Return all the previously stored CustomApp objects.
     *
     * @return a list, potentially empty
     * @see #storeAll(java.util.List)
     */
    List<CustomApp> getAll();

    /**
     * Store the given list of CustomApp objects, replacing any previous values.
     *
     * @param apps a list of {@link CustomApp} object. Can be null to delete the previous list.
     * @see #getAll()
     */
    void storeAll(@Nullable List<CustomApp> apps);

    /**
     * Return whether the custom order flag is set to true
     * @return true if the flag was set, false otherwise
     * @see #setCustomOrder()
     */
    boolean isCustomOrder();

    /**
     * Set the custom order flag to true.
     * @see #isCustomOrder() 
     */
    void setCustomOrder();
}
