package com.atlassian.plugins.custom_apps;

import com.atlassian.plugins.custom_apps.api.CustomApp;
import com.google.common.base.Predicate;

import javax.annotation.Nullable;

/**
 * Predicates for CustomApp
 *
 * @since v3.1.15
 */
public enum CustomAppPredicates implements Predicate<CustomApp>
{
    hasNoSourceApplicationUrl() {
        @Override
        public boolean apply(CustomApp app)
        {
            return app.getSourceApplicationUrl() == null;
        }
    };
}
