/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink;

import com.google.common.base.Objects;

public class CustomContentLink {
    private final String url;
    private final String label;
    private final String key;
    private final Integer id;
    private final Integer sequence;

    private CustomContentLink(Builder builder) {
        this.url = builder.url;
        this.label = builder.label;
        this.key = builder.key;
        this.id = builder.id;
        this.sequence = builder.sequence;
    }

    public Integer getId() {
        return this.id;
    }

    public String getContentKey() {
        return this.key;
    }

    public String getLinkLabel() {
        return this.label;
    }

    public String getLinkUrl() {
        return this.url;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.url, this.label, this.key, this.id});
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass().equals(other.getClass())) {
            CustomContentLink entity = (CustomContentLink)other;
            return Objects.equal((Object)this.url, (Object)entity.url) && Objects.equal((Object)this.label, (Object)entity.label) && Objects.equal((Object)this.key, (Object)entity.key) && Objects.equal((Object)this.id, (Object)entity.id);
        }
        return false;
    }

    public String toString() {
        return "CustomContentLink [id=" + this.id + ", url=" + this.url + ", label=" + this.label + ", key=" + this.key + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String label;
        private String key;
        public Integer id;
        public Integer sequence;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder sequence(int sequence) {
            this.sequence = sequence;
            return this;
        }

        public CustomContentLink build() {
            if (this.sequence == null) {
                this.sequence = 0;
            }
            return new CustomContentLink(this);
        }
    }
}

