package com.atlassian.plugins.capabilities.api;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.joda.time.DateTime;

import com.google.common.collect.ImmutableMap;

/**
 * A value object representing an application that exposes capabilities, and provides 
 * a look up service the URL of the capability.
 *
 * @since 3.1.9
 */
public interface AppWithCapabilities
{
    /**
     * a canonical value representing the application type
     */
    @Nonnull
    public String getType();

    /**
     * Build date of the application, or a 'null' date (01/01/1970 UTC) if unknown.
     *
     * @return build date of the application
     */
    @Nonnull
    public DateTime getBuildDate();

    /**
     * 
     * @return true if the application exposes any capabilities
     */
    public boolean hasCapabilities();

    /**
     * 
     * @param key
     * @return true if the application has this capability
     */
    public boolean hasCapability(String key);

    /**
     * 
     * @param key
     * @return the url for the capability, or null if the application does not have this capability
     */
    @Nullable
    public String getCapabilityUrl(String key);
    
    /**
     * the map of capabilities to capability urls provided by the application.
     * @return
     */
    @Nonnull
    public ImmutableMap<String, String> getCapabilities();
}
