/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devstatus;

import com.atlassian.annotations.PublicApi;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.remote.CoalescingRemoteEvent;
import com.atlassian.event.remote.annotation.Capability;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

@AsynchronousPreferred
@Capability(value="update-devtool-summary-request")
@PublicApi
public class IssueChangedEvent
extends CoalescingRemoteEvent {
    private Collection<String> issueKeys = Collections.emptyList();

    public IssueChangedEvent() {
    }

    public IssueChangedEvent(@Nonnull String issueKey) {
        this(Collections.singletonList(Preconditions.checkNotNull((Object)issueKey)));
    }

    public IssueChangedEvent(@Nonnull Collection<String> issueKeys) {
        this.issueKeys = issueKeys;
    }

    @Nonnull
    public Collection<String> getIssueKeys() {
        return this.issueKeys;
    }

    public CoalescingRemoteEvent coalesce(CoalescingRemoteEvent other) {
        if (other instanceof IssueChangedEvent) {
            return new IssueChangedEvent((Collection<String>)ImmutableList.builder().addAll(this.issueKeys).addAll(((IssueChangedEvent)other).issueKeys).build());
        }
        throw new IllegalArgumentException("Expected " + IssueChangedEvent.class + " but got: " + other.getClass());
    }
}

