/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.features.rest;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.plugins.features.rest.DefaultResponse;
import com.atlassian.plugins.features.rest.FeatureKeyValidation;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/site")
@Produces(value={"application/json"})
@Singleton
public class SiteDarkFeatureResource {
    public static final String FEATURE_KEY_QUERY_PARAM = "featureKey";
    private final DarkFeatureManager darkFeaturesManager;

    @Inject
    public SiteDarkFeatureResource(DarkFeatureManager darkFeaturesManager) {
        this.darkFeaturesManager = darkFeaturesManager;
    }

    @PUT
    @WebSudoRequired
    public Response enableFeaturesForAllUsers(@QueryParam(value="featureKey") List<String> featureKeys) {
        if (!this.darkFeaturesManager.canManageFeaturesForAllUsers()) {
            return DefaultResponse.respondWith(Response.Status.FORBIDDEN);
        }
        if (featureKeys.stream().anyMatch(FeatureKeyValidation.INVALID_FEATURE_KEY)) {
            return DefaultResponse.respondWith(Response.Status.BAD_REQUEST);
        }
        for (String featureKey : featureKeys) {
            this.darkFeaturesManager.enableFeatureForAllUsers(featureKey);
        }
        return DefaultResponse.respondWith(Response.Status.CREATED);
    }

    @DELETE
    @WebSudoRequired
    public Response disableFeatureForAllUsers(@QueryParam(value="featureKey") List<String> featureKeys) {
        if (!this.darkFeaturesManager.canManageFeaturesForAllUsers()) {
            return DefaultResponse.respondWith(Response.Status.FORBIDDEN);
        }
        if (featureKeys.stream().anyMatch(FeatureKeyValidation.INVALID_FEATURE_KEY)) {
            return DefaultResponse.respondWith(Response.Status.BAD_REQUEST);
        }
        for (String featureKey : featureKeys) {
            this.darkFeaturesManager.disableFeatureForAllUsers(featureKey);
        }
        return DefaultResponse.respondWith(Response.Status.NO_CONTENT);
    }

    @GET
    @LicensedOnly
    public Response getFeatureEnabledForAllUsers(@QueryParam(value="featureKey") String featureKey) {
        if (featureKey == null) {
            return this.getFeaturesEnabledForAllUsers();
        }
        return this.isFeatureEnabledForAllUsers(featureKey);
    }

    private Response isFeatureEnabledForAllUsers(String featureKey) {
        Response.Status status = this.darkFeaturesManager.isEnabledForAllUsers(featureKey).orElse(false) != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        return DefaultResponse.respondWith(status);
    }

    private Response getFeaturesEnabledForAllUsers() {
        Set featureKeys = this.darkFeaturesManager.getFeaturesEnabledForAllUsers().getFeatureKeySet();
        return DefaultResponse.respondWith(Response.Status.OK, featureKeys);
    }
}

