/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.features.rest;

import com.atlassian.plugins.features.rest.DefaultResponse;
import com.atlassian.plugins.features.rest.FeatureKeyValidation;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/user")
@Produces(value={"application/json"})
public class UserDarkFeatureResource {
    private final DarkFeatureManager darkFeaturesManager;

    public UserDarkFeatureResource(DarkFeatureManager darkFeaturesManager) {
        this.darkFeaturesManager = darkFeaturesManager;
    }

    @PUT
    public Response enableFeaturesForCurrentUser(@QueryParam(value="featureKey") List<String> featureKeys) {
        if (!Iterables.isEmpty((Iterable)Iterables.filter(featureKeys, FeatureKeyValidation.INVALID_FEATURE_KEY))) {
            return DefaultResponse.respondWith(Response.Status.BAD_REQUEST);
        }
        for (String featureKey : featureKeys) {
            this.darkFeaturesManager.enableFeatureForCurrentUser(featureKey);
        }
        return DefaultResponse.respondWith(Response.Status.CREATED);
    }

    @DELETE
    public Response disableFeaturesForCurrentUser(@QueryParam(value="featureKey") List<String> featureKeys) {
        if (!Iterables.isEmpty((Iterable)Iterables.filter(featureKeys, FeatureKeyValidation.INVALID_FEATURE_KEY))) {
            return DefaultResponse.respondWith(Response.Status.BAD_REQUEST);
        }
        for (String featureKey : featureKeys) {
            this.darkFeaturesManager.disableFeatureForCurrentUser(featureKey);
        }
        return DefaultResponse.respondWith(Response.Status.NO_CONTENT);
    }

    @GET
    public Response getFeatureEnabledForCurrentUser(@QueryParam(value="featureKey") String featureKey) {
        if (featureKey == null) {
            return this.getFeaturesEnabledForCurrentUser();
        }
        return this.isFeatureEnabledForCurrentUser(featureKey);
    }

    private Response isFeatureEnabledForCurrentUser(String featureKey) {
        Response.Status status = this.darkFeaturesManager.isFeatureEnabledForCurrentUser(featureKey) ? Response.Status.OK : Response.Status.NOT_FOUND;
        return DefaultResponse.respondWith(status);
    }

    private Response getFeaturesEnabledForCurrentUser() {
        ImmutableSet featureKeys = this.darkFeaturesManager.getFeaturesEnabledForCurrentUser().getFeatureKeys();
        return DefaultResponse.respondWith(Response.Status.OK, featureKeys);
    }
}

