/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.features.rest;

import com.atlassian.plugins.features.rest.DefaultResponse;
import com.atlassian.plugins.features.rest.FeatureKeyValidation;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/site")
@Produces(value={"application/json"})
public class SiteDarkFeatureResource {
    public static final String FEATURE_KEY_QUERY_PARAM = "featureKey";
    private final DarkFeatureManager darkFeaturesManager;

    public SiteDarkFeatureResource(DarkFeatureManager darkFeaturesManager) {
        this.darkFeaturesManager = darkFeaturesManager;
    }

    @PUT
    @WebSudoRequired
    public Response enableFeaturesForAllUsers(@QueryParam(value="featureKey") List<String> featureKeys) {
        if (!this.darkFeaturesManager.canManageFeaturesForAllUsers()) {
            return DefaultResponse.respondWith(Response.Status.FORBIDDEN);
        }
        if (!Iterables.isEmpty((Iterable)Iterables.filter(featureKeys, FeatureKeyValidation.INVALID_FEATURE_KEY))) {
            return DefaultResponse.respondWith(Response.Status.BAD_REQUEST);
        }
        for (String featureKey : featureKeys) {
            this.darkFeaturesManager.enableFeatureForAllUsers(featureKey);
        }
        return DefaultResponse.respondWith(Response.Status.CREATED);
    }

    @DELETE
    @WebSudoRequired
    public Response disableFeatureForAllUsers(@QueryParam(value="featureKey") List<String> featureKeys) {
        if (!this.darkFeaturesManager.canManageFeaturesForAllUsers()) {
            return DefaultResponse.respondWith(Response.Status.FORBIDDEN);
        }
        if (!Iterables.isEmpty((Iterable)Iterables.filter(featureKeys, FeatureKeyValidation.INVALID_FEATURE_KEY))) {
            return DefaultResponse.respondWith(Response.Status.BAD_REQUEST);
        }
        for (String featureKey : featureKeys) {
            this.darkFeaturesManager.disableFeatureForAllUsers(featureKey);
        }
        return DefaultResponse.respondWith(Response.Status.NO_CONTENT);
    }

    @GET
    @AnonymousAllowed
    public Response getFeatureEnabledForAllUsers(@QueryParam(value="featureKey") String featureKey) {
        if (featureKey == null) {
            return this.getFeaturesEnabledForAllUsers();
        }
        return this.isFeatureEnabledForAllUsers(featureKey);
    }

    private Response isFeatureEnabledForAllUsers(String featureKey) {
        Response.Status status = this.darkFeaturesManager.isFeatureEnabledForAllUsers(featureKey) ? Response.Status.OK : Response.Status.NOT_FOUND;
        return DefaultResponse.respondWith(status);
    }

    private Response getFeaturesEnabledForAllUsers() {
        ImmutableSet featureKeys = this.darkFeaturesManager.getFeaturesEnabledForAllUsers().getFeatureKeys();
        return DefaultResponse.respondWith(Response.Status.OK, featureKeys);
    }
}

