/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.awareness.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.plugins.awareness.rest.representations.ApplicationRepresentation;
import com.atlassian.plugins.awareness.rest.representations.ApplicationsResponseRepresentation;
import com.atlassian.plugins.awareness.rest.representations.LinksRepresentation;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

@Path(value="/")
@Produces(value={"application/json"})
public class AwarenessCapabilityResource {
    private final ApplicationLinkService applicationLinkService;
    private final InternalHostApplication internalHostApplication;

    public AwarenessCapabilityResource(ApplicationLinkService applicationLinkService, InternalHostApplication internalHostApplication) {
        this.applicationLinkService = applicationLinkService;
        this.internalHostApplication = internalHostApplication;
    }

    @GET
    public Response getApplications() {
        HashMap<String, ApplicationRepresentation> applicationRepresentations = new HashMap<String, ApplicationRepresentation>();
        Iterable appLinks = Iterables.filter((Iterable)this.applicationLinkService.getApplicationLinks(), (Predicate)new Predicate<ApplicationLink>(){

            public boolean apply(ApplicationLink input) {
                return input.isSystem();
            }
        });
        for (ApplicationLink appLink : appLinks) {
            String displayUrl = appLink.getDisplayUrl().toString();
            String instanceId = AwarenessCapabilityResource.getInstanceId(displayUrl);
            String href = StringUtils.stripEnd((String)this.internalHostApplication.getBaseUrl().toString(), (String)"/") + "/rest/capabilities/awareness/" + instanceId;
            applicationRepresentations.put(AwarenessCapabilityResource.getCapabilitiesUrl(displayUrl), new ApplicationRepresentation(href, appLink.isSystem(), instanceId));
        }
        return Response.ok((Object)new ApplicationsResponseRepresentation(this.getLinkRepresentation(), applicationRepresentations)).build();
    }

    private LinksRepresentation getLinkRepresentation() {
        String baseUrl = this.internalHostApplication.getBaseUrl().toString();
        String capabilitiesUrl = AwarenessCapabilityResource.getCapabilitiesUrl(baseUrl);
        String instanceId = AwarenessCapabilityResource.getInstanceId(baseUrl);
        return new LinksRepresentation(capabilitiesUrl + "/awareness", capabilitiesUrl, instanceId);
    }

    private static String getCapabilitiesUrl(String applinkDisplayUrl) {
        return StringUtils.stripEnd((String)applinkDisplayUrl, (String)"/") + "/rest/capabilities";
    }

    private static String getInstanceId(String applinkDisplayUrl) {
        return DigestUtils.shaHex(AwarenessCapabilityResource.getCapabilitiesUrl(applinkDisplayUrl));
    }
}

