/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.depview.rest;

import com.atlassian.depview.rest.BundlesResource;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.ws.rs.core.UriBuilder;

public class UriGenerator {
    private final ApplicationProperties applicationProperties;
    private static final String restPath = "/rest/depview/1.0/";
    private final AtomicReference<String> baseUrl = new AtomicReference();

    @Inject
    public UriGenerator(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    private String getBaseUrl() {
        if (this.baseUrl.get() == null) {
            this.baseUrl.compareAndSet(null, this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + restPath);
        }
        return this.baseUrl.get();
    }

    public URI bundleToPlugins() {
        return UriBuilder.fromPath((String)this.getBaseUrl()).path(BundlesResource.class).path(BundlesResource.class, "getToPlugins").build(new Object[0]);
    }

    private URI bundleLink(Long bundleId, String method) {
        return UriBuilder.fromPath((String)this.getBaseUrl()).path(BundlesResource.class).path(BundlesResource.class, method).build(new Object[]{bundleId});
    }

    private String firstCap(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public URI bundle(Long bundleId) {
        return this.bundleLink(bundleId, "getBundle");
    }

    public URI bundleInfo(Long bundleId, String info) {
        return this.bundleLink(bundleId, "get" + this.firstCap(info));
    }
}

