/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.depview.rest;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceBean {
    @XmlAttribute
    private final Long bundleId;
    @XmlElement
    private final Map<String, Object> properties;
    @XmlElement
    private final Collection<Long> usingBundles;

    public ServiceBean(ServiceReference serviceReference) {
        this.bundleId = serviceReference.getBundle().getBundleId();
        this.usingBundles = Optional.ofNullable(serviceReference.getUsingBundles()).map(services -> Arrays.stream(services).map(b -> b.getBundleId()).collect(Collectors.toList())).orElse(Collections.emptyList());
        this.properties = Arrays.stream(serviceReference.getPropertyKeys()).collect(Collectors.toMap(k -> k, k -> {
            Object value = serviceReference.getProperty(k);
            if (value instanceof Version) {
                return value.toString();
            }
            return value;
        }));
    }

    public Long getBundleId() {
        return this.bundleId;
    }

    public Collection<Long> getUsingBundles() {
        return this.usingBundles;
    }
}

