package com.atlassian.depview.rest;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

@XmlAccessorType(XmlAccessType.FIELD)
public class ModuleBean {

    @XmlAttribute
    private final String pluginKey;

    @XmlAttribute
    private final String pluginName;

    @XmlAttribute
    private final String moduleKey;

    @XmlAttribute
    private final String moduleName;

    @XmlAttribute
    private final String moduleClass;

    @XmlAttribute
    private final String moduleState;


    public ModuleBean(String pluginKey,
                      String pluginName,
                      String key,
                      String moduleName,
                      Class moduleClass,
                      Boolean isEnabled) {
        this.pluginKey = pluginKey;

        this.pluginName = pluginName;

        this.moduleKey = key;

        this.moduleClass = moduleClass != null ?
                moduleClass.getSimpleName()
                : "N/A";

        this.moduleName = moduleName == null ? "Nil" : moduleName;

        this.moduleState = isEnabled
                ? "ENABLED"
                : "DISABLED";
    }
}
