package com.atlassian.depview.rest;

import com.google.common.collect.Maps;
import org.osgi.framework.BundleContext;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@XmlAccessorType(XmlAccessType.FIELD)
public class BundleListBean {
    @XmlAttribute
    private final Collection<BundleBean> bundles;

    @XmlElement
    private final Map<String, URI> links;

    public BundleListBean(final UriGenerator uriGenerator, final BundleContext bundleContext, final Optional<String> query) {
        bundles = Arrays.stream(bundleContext.getBundles())
                .map(b -> new BundleBean(uriGenerator, b, query))
                .collect(Collectors.toList());
        links = Maps.newHashMap();
        links.put("plugins", uriGenerator.bundleToPlugins());
    }
}
