(function () {
    var computePreferenceUrl = function ($input) {
        var staticPreferenceUrl = $input.attr("data-notifications-module-preference-rest-url");
        if (staticPreferenceUrl !== undefined) {
            return AJS.contextPath() + staticPreferenceUrl;
        } else {
            return AJS.contextPath() + "/rest/notifications/1.0/user/notifications/" + $input.val();
        }
    };

    var prefsHandler = function (e) {
        var $checkbox = AJS.$(this), type = "DELETE";
        var isChecked = $checkbox.is(":checked");

        if (isChecked) {
            type = "PUT";
        }
        var $throbber = AJS.$("<span class=\"icon throbber loading\"></span>");
        $checkbox.hide().after($throbber);
        AJS.trigger("notifications.userpreferences.changed.start", isChecked);

        AJS.$.ajax({
            url: computePreferenceUrl($checkbox),
            type: type,
            contentType: "application/json",
            success: function () {
                $throbber.remove();
                $checkbox.show();
                AJS.trigger("notifications.userpreferences.changed.end", isChecked);
            },
            error: function (resp) {
                alert(AJS.I18n.getText("notifications.plugin.unknown.error"));
                if ($checkbox.is(":checked")) {
                    $checkbox.removeAttr("checked");
                } else {
                    $checkbox.attr("checked", "checked");
                }
                $throbber.remove();
                $checkbox.show();
                AJS.trigger("notifications.userpreferences.changed.end", {error: resp});
            }
        });
    };

    var mappingHandler = function (e) {
        e.preventDefault();
        var postData = {mappings: AJS.$(this).serializeArray()};

        AJS.$("#user-server-mapping-form .success-msg").empty();

        AJS.$(AJS.$.ajax({
            url: AJS.contextPath() + "/rest/notifications/1.0/user/mapping",
            type: "PUT",
            contentType: "application/json",
            data: JSON.stringify(postData),
            success: function () {
                AJS.messages.success("#user-server-mapping-form .success-msg", {
                    title: AJS.I18n.getText("notifications.user.mapping.saved"),
                    closeable: false
                })
            },
            error: function (resp) {
                alert(AJS.I18n.getText("notifications.plugin.unknown.error"));
            }
        })).throbber({target: "#user-server-mapping-form .throbber"});
    };

    AJS.$(function () {
        var $body = AJS.$("body");
        $body.undelegate("#user-prefs-form input.checkbox");
        $body.undelegate("#user-server-mapping-form");

        $body.delegate("#user-prefs-form input.checkbox", "change", prefsHandler);
        $body.delegate("#user-server-mapping-form", "submit", mappingHandler);

        //AJS.HelpTip only works in JIRA currently :(.
        if (typeof AJS.HelpTip !== 'undefined') {
            $body.bind("notifications-panel-loaded", function () {
                var anchor = AJS.$(".first-server-mapping");

                if (anchor.length > 0) {
                    var serverMappingTip = new AJS.HelpTip({
                        id: "notification.server.identity",
                        title: AJS.I18n.getText("notifications.plugin.user.help.tip.title"),
                        body: AJS.I18n.getText("notifications.plugin.user.help.tip.body", AJS.Meta.get("remote-user")),
                        anchor: anchor
                    });

                    anchor.focus(function () {
                        serverMappingTip.dismiss();
                    });

                    serverMappingTip.show();
                }
            });
        }
    });
})();