(function () {
    AJS.$(function () {

        var getUrlParameter = function (name) {
            return decodeURI((new RegExp(name + '=' + '(.+?)(&|$)').exec(location.search) || [, null])[1]
            );
        };

        var renderScheme = function (model) {
            var schemeView = new Atlassian.Notifications.NotificationSchemeView({
                model: model,
                el: AJS.$("#scheme-admin")
            });
            schemeView.render();
        };

        var scheme = new Atlassian.Notifications.NotificationSchemeModel();
        scheme.fetch({
            success: function () {
                renderScheme(scheme);
            }
        });

        //hookup deleting schemes
        AJS.$(".delete-scheme-lnk").click(function (e) {
            e.preventDefault();
            if (confirm(AJS.I18n.getText("notifications.plugin.delete.scheme.confirm"))) {
                AJS.$.ajax({
                    url: AJS.$(this).attr("href"),
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    },
                    error: function () {
                        alert(AJS.I18n.getText("notifications.plugin.unknown.error"));
                    }
                });
            }
        })
    });
})();