(function () {

    var initAddForm = function (context) {
        var $mediumSelect = AJS.$("#notification-medium", context);

        context.find('.js-server-multi-group-picker').chosen();

        $mediumSelect.change(function (e) {
            var $configForm = AJS.$(".config-form", context);
            $configForm.addClass("config-loading");
            var $this = AJS.$(this);
            var medium = $this.val();
            AJS.$.ajax({
                url: AJS.contextPath() + "/rest/notifications/1.0/config/" + medium,
                success: function (resp) {
                    $configForm.html(resp).removeClass("config-loading");
                },
                error: function (resp) {
                    alert(AJS.I18n.getText("notifications.plugin.error.retrieving.config"));
                    $configForm.removeClass("config-loading");
                }
            });
        });

        AJS.$("#notification-medium", context).change();
    };

    AJS.$(function () {
        AJS.$("#add_server").click(function (e) {
            e.preventDefault();
            var dialog = new Notifications.FormDialog({
                trigger: this,
                id: this.id + "-dialog",
                decorateContents: initAddForm
            });
            dialog.show();
        });

        AJS.$("a.server-dialog-trigger.edit-lnk").click(function (e) {
            e.preventDefault();
            var dialog = new Notifications.FormDialog({
                trigger: this,
                id: this.id + "-dialog",
                decorateContents: initAddForm,
                edit: true
            });
            dialog.show();
        });

        var generatePopup = function (contents, trigger, doShowPopup) {
            contents.html(Notification.Templates.restrictionPopup({
                "groups": AJS.$(trigger).text()
            }));
            doShowPopup();
        };

        AJS.InlineDialog(AJS.$("a.server-restriction-trigger"), "server-restriction-popup", generatePopup);

        AJS.$("#notification-server-list .delete-lnk").click(function (e) {
            e.preventDefault();
            if (confirm(AJS.I18n.getText("notifications.plugin.delete.confirm"))) {
                AJS.$.ajax({
                    url: AJS.$(this).attr("href"),
                    type: "DELETE",
                    contentType: "application/json",
                    success: function (resp) {
                        window.location.reload();
                    },
                    error: function (resp) {
                        alert(AJS.I18n.getText("notifications.plugin.delete.error"));
                    }
                });
            }
        });

        AJS.$(".toolbar-item").tipsy({delayIn: 400, gravity: 'ne'});
        AJS.$(".notifications-toggle").click(function (e) {
            e.preventDefault();

            var $this = AJS.$(this);
            if ($this.hasClass("disabled")) {
                return;
            }

            var currentStatus = $this.data("current");
            var result = true;
            if (currentStatus) {
                result = confirm(AJS.I18n.getText("notifications.plugin.mute.confirm"));
            }
            if (result) {
                AJS.$.ajax({
                    url: $this.attr("href"),
                    type: "PUT",
                    contentType: "application/json",
                    data: JSON.stringify({enabled: !currentStatus}),
                    success: function () {
                        window.location.reload();
                    },
                    error: function () {
                        alert(AJS.I18n.getText("notifications.plugin.unknown.error"));
                    }
                });
            }
        });
    });
})();
