AJS.namespace("Atlassian.Notifications.NotificationSchemeModel");

Atlassian.Notifications.NotificationSchemeModel = Backbone.Model.extend({

    properties:["id", "name", "description", "notifications"],
    urlRoot:AJS.contextPath() + "/rest/notifications/1.0/scheme",

    parse:function(resp) {
        return {
            id:resp.id,
            name:resp.name,
            description:resp.description,
            filterSummary:resp.filterSummary,
            notifications:new Atlassian.Notifications.NotificationsCollection(resp.notifications, {parse:true})
        }
    }
});