/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.runtime.impl.util;

import com.atlassian.plugin.spring.scanner.ProductFilter;
import com.atlassian.plugin.spring.scanner.runtime.impl.util.ProductFilterUtil;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationIndexReader {
    private static final Logger log = LoggerFactory.getLogger(AnnotationIndexReader.class);

    public static List<String> readIndexFile(String resourceFile, Bundle bundle) {
        URL url = bundle.getEntry(resourceFile);
        return AnnotationIndexReader.readIndexFile(url);
    }

    public static List<String> readAllIndexFilesForProduct(String resourceFile, Bundle bundle, BundleContext bundleContext) {
        ArrayList<String> entries = new ArrayList<String>();
        URL url = bundle.getEntry(resourceFile);
        entries.addAll(AnnotationIndexReader.readIndexFile(url));
        ProductFilter filter = ProductFilterUtil.getFilterForCurrentProduct(bundleContext);
        if (null != filter) {
            entries.addAll(AnnotationIndexReader.readIndexFile(filter.getPerProductFile(resourceFile), bundle));
        }
        return entries;
    }

    public static List<String> readIndexFile(URL url) {
        ArrayList<String> resources = new ArrayList<String>();
        try {
            BufferedReader reader;
            if (null == url) {
                log.debug("Could not find annotation index file (null url).");
                return resources;
            }
            try {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), Charsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                log.debug("Could not find annotation index file " + url);
                return resources;
            }
            String line = reader.readLine();
            while (line != null) {
                resources.add(line);
                line = reader.readLine();
            }
            if (log.isDebugEnabled()) {
                log.debug("Read annotation index file: " + url);
                log.debug("Printing out found annotated beans: ");
                log.debug(((Object)resources).toString());
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read index file [" + url.toString() + "]", e);
        }
        return resources;
    }

    public static Properties readPropertiesFile(URL url) {
        Properties resources = new Properties();
        try {
            BufferedReader reader;
            if (null == url) {
                return resources;
            }
            try {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), Charsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                return resources;
            }
            resources.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read properties file [" + url.toString() + "]", e);
        }
        return resources;
    }

    public static String[] splitProfiles(String profiles) {
        return profiles != null && !profiles.trim().isEmpty() ? profiles.split(",") : new String[]{};
    }

    public static Iterable<String> getIndexFilesForProfiles(String[] profileNames, String indexFileName) {
        ArrayList<String> filesToRead = new ArrayList<String>();
        if (profileNames.length > 0) {
            for (String profileName : profileNames) {
                profileName = (profileName == null ? "" : profileName).trim();
                if (profileName.isEmpty()) continue;
                String fileToRead = "META-INF/plugin-components/profile-" + profileName + "/" + indexFileName;
                filesToRead.add(fileToRead);
            }
        } else {
            String fileToRead = "META-INF/plugin-components/" + indexFileName;
            filesToRead.add(fileToRead);
        }
        return filesToRead;
    }
}

