/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.runtime.impl;

import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.spring.scanner.runtime.impl.util.AnnotationIndexReader;
import java.beans.Introspector;
import java.util.TreeSet;
import org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceProxyFactoryBean;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class ComponentImportBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ComponentImportBeanFactoryPostProcessor.class);
    private final BundleContext bundleContext;
    private String profileName;

    public ComponentImportBeanFactoryPostProcessor(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.profileName = null;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        String[] profileNames = AnnotationIndexReader.splitProfiles(this.profileName);
        TreeSet<String> classNames = new TreeSet<String>();
        for (String fileToRead : AnnotationIndexReader.getIndexFilesForProfiles(profileNames, "imports")) {
            classNames.addAll(AnnotationIndexReader.readAllIndexFilesForProduct(fileToRead, this.bundleContext));
        }
        for (String className : classNames) {
            String[] typeAndName = className.split("#");
            String beanType = typeAndName[0];
            String beanName = typeAndName.length > 1 ? typeAndName[1] : "";
            try {
                Class<?> beanClass = beanFactory.getBeanClassLoader().loadClass(beanType);
                this.registerComponentImportBean(registry, beanClass, beanName);
            }
            catch (ClassNotFoundException e) {
                log.warn("Unable to load class '{}' for component importation purposes.  Skipping...", (Object)beanType);
            }
        }
    }

    private void registerComponentImportBean(BeanDefinitionRegistry registry, Class<?> beanClass, String beanName) {
        String serviceBeanName = beanName;
        if ("".equals(serviceBeanName)) {
            serviceBeanName = Introspector.decapitalize(beanClass.getSimpleName());
        }
        this.registerBeanDefinition(registry, serviceBeanName, "(objectClass=" + beanClass.getName() + ")", beanClass);
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, String filter, Class<?> interfaces) {
        Class<OsgiServiceProxyFactoryBean> osgiServiceProxyFactoryBeanClass = OsgiServiceProxyFactoryBean.class;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(osgiServiceProxyFactoryBeanClass);
        builder.setAutowireMode(3);
        builder.setRole(2);
        if (filter != null && !filter.trim().isEmpty()) {
            builder.addPropertyValue("filter", (Object)filter);
        }
        builder.addPropertyValue("interfaces", (Object)new Class[]{interfaces});
        builder.addPropertyValue("beanClassLoader", (Object)OsgiPlugin.class.getClassLoader());
        AbstractBeanDefinition newDefinition = builder.getBeanDefinition();
        registry.registerBeanDefinition(beanName, (BeanDefinition)newDefinition);
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }
}

