package com.atlassian.plugin.spring.scanner.extension;

import org.osgi.framework.BundleContext;
import org.springframework.core.io.ResourceLoader;

import javax.annotation.Nullable;

/**
 * Abstracts retrieval of BundleContext from the spring-dm or gemini
 * ConfigurableOsgiBundleApplicationContext as appropriate
 */
public interface OsgiBundleContextAccessor {

    /**
     * Get the bundle context from the ResourceLoader.
     *
     * @param resourceLoader expected to be the spring-dm or gemini
     *        ConfigurableOsgiBundleApplicationContext
     * @return bundle context, or null if resourceLoader isn't a suitable instance
     */
    @Nullable
    BundleContext getBundleContext(ResourceLoader resourceLoader);
}
