/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.annotation.Nullable;

public class JavassistHelper {
    public List<String> getClassAnnotationNames(ClassFile aClass) {
        return this.getAnnotationNames((AnnotationsAttribute)aClass.getAttribute("RuntimeVisibleAnnotations"));
    }

    private List<String> getAnnotationNames(AnnotationsAttribute ... annotationsAttributes) {
        if (annotationsAttributes == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(annotationsAttributes).filter(Objects::nonNull).flatMap(annotationsAttribute -> Arrays.stream(annotationsAttribute.getAnnotations())).map(Annotation::getTypeName).collect(Collectors.toList());
    }

    Set<String> getAnnotationMemberSet(ClassFile classFile, String annotationType) {
        MemberValue value = this.getMemberValue(classFile, annotationType);
        if (value instanceof ArrayMemberValue) {
            MemberValue[] arrayMemberValueValues;
            HashSet<String> values = new HashSet<String>();
            ArrayMemberValue arrayMemberValue = (ArrayMemberValue)value;
            for (MemberValue memberValue : arrayMemberValueValues = arrayMemberValue.getValue()) {
                if (memberValue == null) continue;
                values.add(this.removeQuotes(memberValue.toString()));
            }
            return values;
        }
        return Collections.emptySet();
    }

    private MemberValue getMemberValue(ClassFile classFile, String annotationType) {
        AnnotationsAttribute annotations = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        Annotation annotation = annotations.getAnnotation(annotationType);
        return annotation == null ? null : annotation.getMemberValue("value");
    }

    private String removeQuotes(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    String getAnnotationMember(ClassFile classFile, String annotationType) {
        MemberValue value = this.getMemberValue(classFile, annotationType);
        return this.dataForMemberValue(value);
    }

    String getAnnotationMember(@Nullable Annotation annotation) {
        MemberValue value = annotation == null ? null : annotation.getMemberValue("value");
        return this.dataForMemberValue(value);
    }

    private String dataForMemberValue(MemberValue memberValue) {
        if (memberValue instanceof StringMemberValue) {
            return ((StringMemberValue)memberValue).getValue();
        }
        if (memberValue instanceof ClassMemberValue) {
            return ((ClassMemberValue)memberValue).getValue();
        }
        if (memberValue instanceof ArrayMemberValue) {
            MemberValue[] entryValues = ((ArrayMemberValue)memberValue).getValue();
            return Arrays.stream(entryValues).map(this::dataForMemberValue).collect(Collectors.joining(","));
        }
        return memberValue == null ? null : this.removeQuotes(memberValue.toString());
    }

    List<Annotation> getParameterAnnotations(MethodInfo method, int parameterIndex) {
        Annotation[] annotations;
        Annotation[][] allAnnotations;
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        ParameterAnnotationsAttribute parameterAnnotationsAttribute = (ParameterAnnotationsAttribute)method.getAttribute("RuntimeVisibleParameterAnnotations");
        if (parameterAnnotationsAttribute != null && parameterIndex < (allAnnotations = parameterAnnotationsAttribute.getAnnotations()).length && (annotations = allAnnotations[parameterIndex]) != null) {
            Collections.addAll(result, annotations);
        }
        return result;
    }
}

