/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import com.atlassian.plugin.spring.scanner.core.AnnotationValidator;
import com.atlassian.plugin.spring.scanner.core.ByteCodeScannerConfiguration;
import com.atlassian.plugin.spring.scanner.core.ClassScanner;
import com.atlassian.plugin.spring.scanner.core.JavassistHelper;
import com.atlassian.plugin.spring.scanner.core.ProfileFinder;
import com.atlassian.plugin.spring.scanner.core.SpringIndexWriter;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;

public class AtlassianSpringByteCodeScanner {
    private final AnnotationValidator annotationValidator;
    private final ByteCodeScannerConfiguration configuration;
    private final ClassScanner scanner;
    private final SpringIndexWriter springIndexWriter;

    @Nonnull
    public static AtlassianSpringByteCodeScanner getInstance(ByteCodeScannerConfiguration config) {
        AnnotationValidator annotationValidator = new AnnotationValidator();
        Logger log = config.getLog();
        SpringIndexWriter springIndexWriter = new SpringIndexWriter(config.getOutputDirectory());
        ClassScanner reflectionsScanner = new ClassScanner(annotationValidator, new JavassistHelper(), log, new ProfileFinder(config.getClassPathUrls(), log), springIndexWriter, config.isVerbose());
        return new AtlassianSpringByteCodeScanner(annotationValidator, config, reflectionsScanner, springIndexWriter);
    }

    @VisibleForTesting
    AtlassianSpringByteCodeScanner(AnnotationValidator annotationValidator, ByteCodeScannerConfiguration configuration, ClassScanner scanner, SpringIndexWriter springIndexWriter) {
        this.annotationValidator = Objects.requireNonNull(annotationValidator);
        this.configuration = Objects.requireNonNull(configuration);
        this.scanner = Objects.requireNonNull(scanner);
        this.springIndexWriter = Objects.requireNonNull(springIndexWriter);
    }

    public ScanResults scan() {
        Configuration reflectionsConfig = this.configureReflections();
        new Reflections(reflectionsConfig);
        this.springIndexWriter.writeIndexes();
        return this.getScanResults();
    }

    private Configuration configureReflections() {
        ConfigurationBuilder reflectionsConfig = new ConfigurationBuilder();
        reflectionsConfig.setUrls(this.configuration.getClassPathUrls());
        if (StringUtils.isNotBlank((CharSequence)this.configuration.getIncludeExclude())) {
            reflectionsConfig.filterInputsBy((Predicate)FilterBuilder.parse((String)this.configuration.getIncludeExclude()));
        }
        reflectionsConfig.setScanners(new Scanner[]{this.scanner});
        AtlassianSpringByteCodeScanner.suppressReflectionsLogging();
        return reflectionsConfig;
    }

    private static void suppressReflectionsLogging() {
        try {
            Reflections.log = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ScanResults getScanResults() {
        ScanResults results = new ScanResults(this.scanner);
        if (this.configuration.shouldValidate()) {
            results.addErrors(this.annotationValidator.validate());
        }
        return results;
    }

    public static class ScanResults {
        private final int classesEncountered;
        private final int componentClassesEncountered;
        private final List<String> errors = new ArrayList<String>();

        public ScanResults(ClassScanner scanner) {
            this.classesEncountered = scanner.getClassesEncountered();
            this.componentClassesEncountered = scanner.getComponentClassesEncountered();
            this.errors.addAll(scanner.getErrors());
        }

        private void addErrors(List<String> errors) {
            this.errors.addAll(errors);
        }

        public int getClassesEncountered() {
            return this.classesEncountered;
        }

        public int getComponentClassesEncountered() {
            return this.componentClassesEncountered;
        }

        public List<String> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }
    }
}

